<?php
header('Content-Type: application/json; charset=utf-8');
$config = require 'config.php';

// Get the raw POST data
$requestBody = file_get_contents('php://input');
$data = json_decode($requestBody, true);


// Enhanced request logging with multipart form data handling
$logFile = 'request.log';
$logData = [
    'timestamp' => date('Y-m-d H:i:s'),
    'ip_address' => $_SERVER['REMOTE_ADDR'] ?? 'unknown',
    'request_method' => $_SERVER['REQUEST_METHOD'] ?? 'unknown',
    'request_body' => $requestBody,
    'request_headers' => getallheaders(),
    'content_type' => $_SERVER['CONTENT_TYPE'] ?? 'unknown',
    'user_agent' => $_SERVER['HTTP_USER_AGENT'] ?? 'unknown',
    'referer' => $_SERVER['HTTP_REFERER'] ?? 'unknown',
    'request_uri' => $_SERVER['REQUEST_URI'] ?? 'unknown'
];

// Add security-related logging
$logData['security'] = [
    'is_https' => isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on',
    'origin' => $_SERVER['HTTP_ORIGIN'] ?? 'unknown',
    'forwarded_for' => $_SERVER['HTTP_X_FORWARDED_FOR'] ?? 'none'
];

// Handle multipart form data
if (strpos($logData['content_type'], 'multipart/form-data') !== false) {
    $logData['form_data'] = $_POST;
    // Safely log file uploads without storing sensitive data
    if (!empty($_FILES)) {
        $logData['files'] = array_map(function($file) {
            return [
                'name' => $file['name'],
                'type' => $file['type'],
                'size' => $file['size']
            ];
        }, $_FILES);
    }
}

$logEntry = json_encode($logData, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
file_put_contents($logFile, $logEntry . "\n---\n", FILE_APPEND | LOCK_EX);

// Add request validation for multipart form data
if (strpos($_SERVER['CONTENT_TYPE'], 'multipart/form-data') !== false) {
    $data = $_POST;
}



// Validate required parameters
$requiredFields = [
    'amount',
    'payee_name',
    'payee_bank_code',
    'payee_bank_account',
    'payee_phone',
    'order_number',
    'url',
    'redirect_url' // Add redirect_url as a required field
];

foreach ($requiredFields as $field) {
    if (empty($data[$field])) {
        echo json_encode(['error' => "$field is required"]);
        http_response_code(400);
        exit;
    }
}

$channel_cashflow_id = 12; // Hardcoded for testing
$amount = htmlspecialchars($data['amount']);
$payee_name = htmlspecialchars($data['payee_name']);
$payee_bank_code = htmlspecialchars($data['payee_bank_code']);
$payee_bank_account = htmlspecialchars($data['payee_bank_account']);
$payee_phone = htmlspecialchars($data['payee_phone']);
$order_number = htmlspecialchars($data['order_number']);
$url = "https://91xwin.site/pay/callback_widthdraw.php"; // <-- hardcoded
$redirect_url = "https://91xwin.site/pay/callback_widthdraw.php"; // <-- hardcoded


// API configuration
$apiUrl = $config['new_api_url_pay']; // Update with the new API URL
$apiKey = $config['api_key']; // API key for authentication

// Prepare the request payload
$params = [
    'channel_cashflow_id' => $channel_cashflow_id,
    'amount' => $amount,
    'payee_name' => $payee_name,
    'payee_bank_code' => $payee_bank_code,
    'payee_bank_account' => $payee_bank_account,
    'payee_phone' => $payee_phone,
    'order_number' => $order_number,
    'url' => $url,
    'redirect_url' => $redirect_url // Include redirect_url in the payload
];

// Log the payload to a file
$logFile = 'api_request.log'; // Log file path
$logData = date('Y-m-d H:i:s') . " - Payload: " . json_encode($params, JSON_PRETTY_PRINT) . "\n";
file_put_contents($logFile, $logData, FILE_APPEND | LOCK_EX);

// Log the request parameters for debugging
error_log('Payload: ' . json_encode($params));

// Send the request to the API
$ch = curl_init($apiUrl);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($params));
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Content-Type: application/json',
    'Authorization: Bearer ' . $apiKey,
]);

$response = curl_exec($ch);

if (curl_errno($ch)) {
    echo json_encode(['error' => curl_error($ch)]);
    http_response_code(500);
} else {
    $responseData = json_decode($response, true);

    // Log the raw API response for debugging
    error_log('Raw API Response: ' . $response);

    if (isset($responseData['code'])) {
        if ($responseData['code'] === 0) {
            echo json_encode([
                'success' => true,
                'data' => [
                    'number' => $responseData['data']['number'] ?? null,
                    'order_number' => $responseData['data']['order_number'] ?? null,
                ]
            ]);
            http_response_code(200);
        } else {
            // Handle specific error codes
            echo json_encode([
                'error' => $responseData['errors']['message'] ?? 'Unexpected API response',
                'code' => $responseData['code']
            ]);
            http_response_code(400);
        }
    } else {
        echo json_encode(['error' => 'Malformed API response']);
        http_response_code(500);
    }
}

curl_close($ch);
?>